/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.ftp.internal;

import com.aptana.core.util.ProgressMonitorInterrupter;
import com.aptana.filesystem.ftp.internal.FTPClientPool;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FTPFileDownloadInputStream
extends InputStream {
    private FTPClientInterface ftpClient;
    private FileTransferInputStream ftpInputStream;
    private FTPClientPool pool;

    public FTPFileDownloadInputStream(FTPClientPool pool, FTPClientInterface _ftpClient, FileTransferInputStream ftpInputStream) {
        this.ftpClient = _ftpClient;
        this.pool = pool;
        this.ftpInputStream = ftpInputStream;
        ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)new ProgressMonitorInterrupter.InterruptDelegate(){

            public void interrupt() {
                try {
                    if (FTPFileDownloadInputStream.this.ftpClient.connected()) {
                        FTPFileDownloadInputStream.this.ftpClient.quitImmediately();
                    }
                }
                catch (Exception ignore) {
                    ignore.getCause();
                }
            }
        });
    }

    private void safeQuit() {
        try {
            this.ftpInputStream.close();
        }
        catch (IOException ignore) {
            ignore.getCause();
        }
        this.pool.checkIn(this.ftpClient);
        ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
    }

    public int read() throws IOException {
        try {
            return this.ftpInputStream.read();
        }
        catch (IOException e) {
            this.safeQuit();
            throw e;
        }
    }

    public int available() throws IOException {
        try {
            return this.ftpInputStream.available();
        }
        catch (IOException e) {
            this.safeQuit();
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.ftpInputStream.close();
        }
        finally {
            this.safeQuit();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.ftpInputStream.read(b, off, len);
        }
        catch (IOException e) {
            this.safeQuit();
            throw e;
        }
    }
}

